function camelize(str) {
  const camelizeRE = /-(\w)/g;
  return str.replace(camelizeRE, (_, c) => (c ? c.toUpperCase() : ""));
}

function bytesToSize(bytes) {
  if (bytes === 0) return "0 B";

  var k = 1024;
  var sizes = ["B", "KiB", "MiB", "GiB", "TiB", "PiB", "EiB", "ZiB", "YiB"];
  var i = Math.floor(Math.log(bytes) / Math.log(k));
  return (bytes / Math.pow(k, i)).toPrecision(3) + " " + sizes[i];
}

function passwordStrength(pwd) {
  const checks = {
    chars: {
      guide: "Minimal 8 karakter",
      ok: false,
    },
    lower: {
      guide: "Minimal 1 huruf kecil",
      ok: false,
    },
    upper: {
      guide: "Minimal 1 huruf besar",
      ok: false,
    },
    number: {
      guide: "Minimal 1 angka",
      ok: false,
    },
  };

  if (pwd) {
    if (pwd.length >= 8) checks.chars.ok = true;
    if (/[a-z]/.test(pwd)) checks.lower.ok = true;
    if (/[A-Z]/.test(pwd)) checks.upper.ok = true;
    if (/\d/.test(pwd)) checks.number.ok = true;
  }

  return checks;
}

module.exports = { camelize, bytesToSize, passwordStrength };
